<?php

namespace App\Services\JiraDescriptions;

use App\Models\Asset;
use App\User;
use Illuminate\Support\Facades\Auth;
use Facades\App\Services\AssetHistory as AssetHistoryService;
use App\Http\Traits\JiraPluginTrait;
use App\Models\Location;

class DescriptionForInRepair implements JiraDescription
{
	use JiraPluginTrait;

	/**
	 * Generates a description for in repair status change in Jira.
	 *
	 * @param string $status The new status of the asset.
	 * @param array $data Additional data for the description.
	 * @param \App\Models\Asset $asset The asset being described.
	 * @param string|null $comments Optional comments for the description.
	 *
	 * @return string The formatted description string.
	 */
	function description($status, $data, $asset, $comments = null)
	{

		$toName = AssetHistoryService::getToLocationOrUsername($data);
		$oldUserName = AssetHistoryService::getOldLocationOrUsername($asset);
		$oldUserName = ($oldUserName != null) ? (' from ' . $oldUserName) : " ";
		$commentstext = formatTicketComment($comments);
		$user = $this->getAuthenticatedUser();

		return __('jira.InRepair', [
			'assetname' => $asset->serial_no,
			'assetid' => $asset->id,
			'oldasset_status' => $asset->assetStatus?->name,
			'newstatus' => $status,
			'commenttext' => $commentstext,
			'username'  => trim($user->first_name . ' ' . $user->last_name),
			'useremail' => trim($user->email),
		]);
	}
}
