<?php

namespace App\Services\JiraDescriptions;

use App\Http\Traits\JiraPluginTrait;
use App\Models\Vendor;

class DescriptionForEndofLifeDataWiped  implements JiraDescription
{
    use JiraPluginTrait;

    /**
     * Generate the Jira description for a End of Life Data Wiped asset.
     *
     * @param string $status The new status of the asset.
     * @param array $data Additional data for the description.
     * @param \App\Models\Asset $asset The asset object containing current asset details.
     * @param string|null $comments Optional comments regarding the asset.
     *
     * @return string The formatted description string.
     */
    function description($status, $data, $asset, $comments = null)
    {

        $toVendor = $data['vendor_id'] ? Vendor::where('id', $data['vendor_id'])->first() : '';
        $commentstext = formatTicketComment($comments);
        $user = $this->getAuthenticatedUser();
        return __('jira.EndofLifeDataWiped', [
            'assetname' => $asset->serial_no,
            'assetid' => $asset->id,
            'oldasset_status' => optional($asset->assetStatus)->name,
            'newstatus' => $status,
            'vendor' => $toVendor?->name,
            'commenttext' => $commentstext,
            'username'  => trim($user->first_name . ' ' . $user->last_name),
            'useremail' => trim($user->email),
        ]);
    }
}
