<?php

namespace App\Services\JiraDescriptions;

use App\Http\Traits\JiraPluginTrait;
use App\Models\AssetStatus;
use App\Models\Location;
use Facades\App\Services\Asset\AssetStatusService;

class DescriptionForAsnRecieved implements JiraDescription
{
  use JiraPluginTrait;

  function description($status, $data, $asset, $comments = null)
  {

    $location = Location::where('id', $data['new_location_id'])->first();
    $commentstext = '';
    $user = $this->getAuthenticatedUser();
    $creatingStatus = AssetStatusService::whenCreatingAsset();
    $assetStatus = AssetStatus::where('slug', $creatingStatus)->first();
    $locationOrUser = $location?->room_name ?? $user->userName;

    return  __('jira.AsnAssigned', [
      'assetname' => $asset->serial_no,
      'assetid' => $asset->id,
      'computername' => $asset->computer_name,
      'oldasset_status' => $asset->assetStatus->name,
      'newstatus' => $assetStatus->name,
      'roomname' => ' to ' . $locationOrUser,
      'commenttext' => $commentstext,
      'username'  => trim($user->first_name . ' ' . $user->last_name),
      'useremail' => trim($user->email),
    ]);
  }
}
