<?php

namespace App\Services\JiraDescriptions;

use App\Models\Asset;
use App\User;
use Illuminate\Support\Facades\Auth;
use Facades\App\Services\AssetHistory as AssetHistoryService;
use App\Http\Traits\JiraPluginTrait;

class DescriptionForAsnAssigned implements JiraDescription
{
  use JiraPluginTrait;

  function description($status, $data, $asset, $comments = null)
  {


    $touser = User::where('id', $data['new_user_id'])->first();
    $tousername = ($touser != null) ? (' to ' . $touser->first_name . ' ' . $touser->last_name) : " ";
    $commentstext = '';

    $user = $this->getAuthenticatedUser();

    return __('jira.AsnAssigned', [
      'assetname' => $asset->serial_no,
      'assetid' => $asset->id,
      'computername' => $asset->computer_name,
      'oldasset_status' => $asset->assetStatus->name,
      'newstatus' => "Assigned",
      'roomname' => $tousername,
      'commenttext' => $commentstext,
      'username'  => trim($user->first_name . ' ' . $user->last_name),
      'useremail' => trim($user->email),
    ]);
  }
}
