<?php
namespace App\Services\Integrations\ShipmentTracking\UPS;

class Ups 
{
	/**
     * Taking the latest shipment status from the UPS api response data
     *
     * @param $shipmentData   UPS shipment API response data
     * @return String 
     */
    public function shipmentLatestStatus($shipmentData)
    {
        $shipmentStatus = array();
        if (isset($shipmentData->TrackResponse)) { //Success response
            $shipmentStatus['success']  = $shipmentData->TrackResponse->Shipment ? 
                ($shipmentData->TrackResponse->Shipment->Package ?
                    (is_array($shipmentData->TrackResponse->Shipment->Package) ? 
                        $this->latestStatusCode($shipmentData->TrackResponse->Shipment->Package[0])
                    :   
                    	$this->latestStatusCode($shipmentData->TrackResponse->Shipment->Package)
                    )
                : null) 
            : null;
        } else if(isset($shipmentData->Fault)) { //Error response
            $shipmentStatus['error']  = $shipmentData->Fault->detail ? 
                ($shipmentData->Fault->detail->Errors ?
                    ($shipmentData->Fault->detail->Errors->ErrorDetail ?
                        ($shipmentData->Fault->detail->Errors->ErrorDetail->PrimaryErrorCode ?
                            $shipmentData->Fault->detail->Errors->ErrorDetail->PrimaryErrorCode->Description
                        : null)
                    : null)
                : null)
            : null;
        }
        return $shipmentStatus;
    }

    /** 
     * Taking the latest ups shipment status from package enitity
     */
    public function latestStatusCode($package)
    {
    	return ($package->Activity ? 
                    ($package->Activity->Status ?
                        $package->Activity->Status->Description
                    : null) 
                : null);
    }


    /**
     * Taking the latest shipment status Name from the UPS api response data
     *
     * @param $shipmentData   UPS shipment API response data
     * @return String 
     */
    public function getShipmentLatestStatusName($shipmentData)
    {
        $shipmentStatus = array();
        if (isset($shipmentData->TrackResponse)) { //Success response
            $shipmentStatus['status']  = $shipmentData->TrackResponse->Shipment ? 
                ($shipmentData->TrackResponse->Shipment->Package ?
                    (is_array($shipmentData->TrackResponse->Shipment->Package) ? 
                        $this->getLatestStatusName($shipmentData->TrackResponse->Shipment->Package[0])
                    :   
                        $this->getLatestStatusName($shipmentData->TrackResponse->Shipment->Package)
                    )
                : null) 
            : null;

            $shipmentStatus['updated_on']  = $shipmentData->TrackResponse->Shipment ? 
                ($shipmentData->TrackResponse->Shipment->Package ?
                    (is_array($shipmentData->TrackResponse->Shipment->Package) ? 
                        $this->getUpdatedOnAttribute($shipmentData->TrackResponse->Shipment->Package[0])
                    :   
                        $this->getUpdatedOnAttribute($shipmentData->TrackResponse->Shipment->Package)
                    )
                : null) 
            : null;

        } else if(isset($shipmentData->Fault)) { //Error response
            $shipmentStatus['updated_on']  = null;
            $shipmentStatus['status']  = $shipmentData->Fault->detail ? 
                ($shipmentData->Fault->detail->Errors ?
                    ($shipmentData->Fault->detail->Errors->ErrorDetail ?
                        ($shipmentData->Fault->detail->Errors->ErrorDetail->PrimaryErrorCode ?
                            $shipmentData->Fault->detail->Errors->ErrorDetail->PrimaryErrorCode->Description
                        : null)
                    : null)
                : null)
            : null;
        }
        return $shipmentStatus;
    }


    /** 
     * Taking the latest ups shipment status name from package enitity
     */
    public function getLatestStatusName($package)
    {
        return ($package->Activity ? 
                    ($package->Activity->Status ?
                        $package->Activity->Status->Description
                    : null) 
                : null);
    }

    /** 
     * Taking the latest ups shipment status update date from package enitity
     */
    public function getUpdatedOnAttribute($package)
    {
        $date = ($package->Activity ?
                        $package->Activity->Date
                : null);

        if (!$date) {
            return null;
        }

        return date("Y-m-d", strtotime($date));
    }

}