<?php

namespace App\Services;

use App\Models\Department;
use App\Models\MakeAndModel;
use DB;
use App\Repositories\HardwarekitRepository;
use Carbon\Carbon;

/**
 * Service Class for Department details and actions
 */
class HardwarekitService
{
    /**
     * Constructor for the DepartmentController
     */
    public function __construct(HardwarekitRepository $hardwarekitRepo)
    {
        $this->hardwarekitRepo = $hardwarekitRepo;
    }
    /**
     * get hardware mapping with the departments
     */
    public function getDepartmentHardwareKitData()
    {
        $departmentHardwareKitData = $this->hardwarekitRepo->DepartmentHardwareKitData();
        return $this->filterWithInputData($departmentHardwareKitData);
    }
    /**
     * It filters the data based on the input fields.
     *
     * @param departmentHardwareKitData This is the data that you want to filter.
     *
     * @return The filtered data is being returned.
     */
    public function filterWithInputData($departmentHardwareKitData)
    {
        $filterDepartments = request('filter_department_id') ? request('filter_department_id') : '';
        $filterMakeAndModels = request('filter_make_and_model_id') ? request('filter_make_and_model_id') : '';
        $departmentHardwareKitData = $this->hardwarekitRepo->filterDataWithInputFields($departmentHardwareKitData, 'department_id', $filterDepartments);
        $departmentHardwareKitData = $this->hardwarekitRepo->filterDataWithInputFields($departmentHardwareKitData, 'make_and_model_id', $filterMakeAndModels);
        return $departmentHardwareKitData;
    }
    /**
     * delete Department Hardwares
     * @param int $departmentId
     */
    public function deleteDepartmentHardwares($departmentId)
    {
        $this->hardwarekitRepo->deleteDepartmentHardwares($departmentId);
    }

    /**
     * update Hardwares of the Department
     * @param array $conditions
     * @param array $data
     */
    public function updateDepartmentHardwares($postData)
    {
        $hardwarekitData = [];
        $now = Carbon::now()->toDateTimeString();
        for ($i = 0; $i < count($postData['make_and_model_id']); $i++) {
            $data = [
                'department_id'     => $postData['department_id'],
                'make_and_model_id' => $postData['make_and_model_id'][$i],
                'technical_spec_id' => $postData['tech_spec_id'][$i],
                'cost'              => $postData['tech_spec_cost'][$i],
                'created_at'        => $now,
                'updated_at'        => $now
            ];
            array_push($hardwarekitData, $data);
        }
        return $this->hardwarekitRepo->updateDepartmentHardwares($hardwarekitData);
    }
}
