<?php

namespace App\Services\HardwareMapping;

use App\Models\AirWatch;
use App\Models\Asset;
use App\Models\Chromebook;
use App\Models\DiscoveryToolsHardwareMapping;
use App\Models\IntuneComputer;
use App\Models\JamfComputer;
use App\Models\KandjiDevices;
use App\Models\MobileIron;
use App\User;

class HardwareMappingDataService
{
    /**
     * Filer the results based on filters
     * 
     * @param $assets DB Query
     * @param Array $inputData   Filter data
     * 
     * @return Query
     */
    public function data()
    {
        $teqtivityHardwares = DiscoveryToolsHardwareMapping::with('makeAndModel');
        if (isset(request('form')['make_and_model']) && request('form')['make_and_model']) {
            if (is_array(request('form')['make_and_model'])) {
                $teqtivityHardwares = $teqtivityHardwares->whereIn('make_and_model_id', request('form')['make_and_model']);
            } else {
                $teqtivityHardwares = $teqtivityHardwares->where('make_and_model_id', request('form')['make_and_model']);
            }
        }

        if (isset(request('form')['mdm_name']) && request('form')['mdm_name']) {
            if (is_array(request('form')['mdm_name'])) {
                $teqtivityHardwares = $teqtivityHardwares->whereIn('mdm_name', request('form')['mdm_name']);
            } else {
                $teqtivityHardwares = $teqtivityHardwares->where('mdm_name', request('form')['mdm_name']);
            }
        }

        if (isset(request('form')['mdm_model']) && request('form')['mdm_model']) {
            if (is_array(request('form')['mdm_model'])) {
                $teqtivityHardwares = $teqtivityHardwares->whereIn('mdm_model', request('form')['mdm_model']);
            } else {
                $teqtivityHardwares = $teqtivityHardwares->where('mdm_model', request('form')['mdm_model']);
            }
        }

        $count = $teqtivityHardwares->count();
        $teqtivityHardwares = $this->getOutputData($teqtivityHardwares);
        return compact('count', 'teqtivityHardwares');
    }

    /**
     * Executing the query
     * @param $teqtivityHardwares Query
     * @return Query Result
     */
    public function getOutputData($teqtivityHardwares)
    {
        $start = request('start');
        $limit = request('length');
        if ($limit != -1) {
            $teqtivityHardwares = $teqtivityHardwares->skip($start)
                ->take($limit);
        }

        $teqtivityHardwares = $teqtivityHardwares->orderBy('id', 'desc');
        return $teqtivityHardwares->get();
    }

    /**
     * Generating data to export
     * @param $teqtivityHardwares Query Result
     * @param $start Starting index
     * @param $data Collection valriable that will return
     * @return array
     */
    public function getReportData($teqtivityHardwares, $start, $data)
    {
        $parentIndex = $start;

        foreach ($teqtivityHardwares as $key => $teqtivityHardware) {
            $parentIndex++;

            $nestedData = $this->getNestedData($teqtivityHardware, $parentIndex);
            $data[] = $nestedData;
        }

        return $data;
    }

    /**
     * Creating array for Data table data
     * @param $teqtivityHardware Query Result
     * @param $index Starting index
     *
     * @return array
     */
    public function getNestedData($teqtivityHardware, $index)
    {
        $mdmNameMappings = config('discovery-tools-hardware-mapping.model_names');
        $nestedData['id']                        = $index;
        $nestedData['hardware_teqtivity']        = optional($teqtivityHardware->makeAndModel)->name;
        $nestedData['mdm_name']                  = $mdmNameMappings[$teqtivityHardware->mdm_name] ?? '';
        $nestedData['mdm_model']                 = $teqtivityHardware->mdm_model;
        $nestedData['action_buttons']            = $this->getActionButtons($teqtivityHardware);

        return $nestedData;
    }

    /**
     * Set up Action Asset Button
     * @param mixed $asset
     */
    public function getActionButtons($teqtivityHardware)
    {
        $actions = '<div style="width:175px">';
        if (auth()->user()->can('Discovery Tools Hardware Mapping') && $teqtivityHardware) {
            $actions .= '<a class="btn btn-link btn-sm btn-edit-discovery-mapping" href="javascript:void(0);" data-rowid="' . $teqtivityHardware->id . '" data-teqmodel="' . $teqtivityHardware->make_and_model_id . '" data-mdmname="' . $teqtivityHardware->mdm_name . '" data-mdmmodel="' . str_replace('"', '&quot;', $teqtivityHardware->mdm_model) . '" data-target="#editModal"><i class="icon icon-n-edit"  ></i></a>';
            $actions  .= '<a  class="btn btn-link btn-sm btn-delete-discovery-mapping"  style="margin-right:4px;" data-rowid="' . $teqtivityHardware->id . '"  data-target="#deleteMappingModal"><i class="icon icon-delete-forever"></i></a>';
        }
        return $actions  .= "</div>";
    }

    /**
     * Returns discovery tools HW standards as key value pairs
     * @param mixed $search
     * 
     * @return [type]
     */
    public function getFilterHardwareMappingFields($search)
    {
        $chromeComputer = Chromebook::select('model')->distinct('model')->where('model', 'like', '%' . $search . '%')->limit(5)->get();
        $intuneComputer = IntuneComputer::select('model')->distinct('model')->where('model', 'like', '%' . $search . '%')->limit(5)->get();
        $jamfComputer = JamfComputer::select('model')->distinct('model')->where('model', 'like', '%' . $search . '%')->limit(5)->get();
        $workspaceOneComputer = AirWatch::select('model')->distinct('model')->where('model', 'like', '%' . $search . '%')->limit(5)->get();
        $kandjiComputer = KandjiDevices::select('model')->distinct('model')->where('model', 'like', '%' . $search . '%')->limit(5)->get();
        $mobileIrons = MobileIron::select('model')->distinct('model')->where('model', 'like', '%' . $search . '%')->limit(5)->get();

        $hardwaresArray = [];
        foreach ($chromeComputer as $item) {
            $hardwaresArray[] = [
                'id' => str_replace('"', '&quot;', $item->model), // replace double quotes with corresponding html entity to prevent clipping of text after first quotes.
                'text' => $item->model,
            ];
        }

        foreach ($intuneComputer as $item) {
            $hardwaresArray[] = [
                'id' => str_replace('"', '&quot;', $item->model),
                'text' => $item->model,
            ];
        }

        foreach ($jamfComputer as $item) {
            $hardwaresArray[] = [
                'id' => str_replace('"', '&quot;', $item->model),
                'text' => $item->model,
            ];
        }

        foreach ($workspaceOneComputer as $item) {
            $hardwaresArray[] = [
                'id' => str_replace('"', '&quot;', $item->model),
                'text' => $item->model,
            ];
        }

        foreach ($kandjiComputer as $item) {
            $hardwaresArray[] = [
                'id' => str_replace('"', '&quot;', $item->model),
                'text' => $item->model,
            ];
        }

        foreach ($mobileIrons as $item) {
            $hardwaresArray[] = [
                'id' => str_replace('"', '&quot;', $item->model),
                'text' => $item->model,
            ];
        }

        $uniqueArray = [];
        $seenIds = [];

        foreach ($hardwaresArray as $item) {
            $id = $item['id'];
            // Check if the id has not been seen before
            if (!in_array($id, $seenIds)) {
                $uniqueArray[] = $item;
                $seenIds[] = $id;
            }
        }
        return $uniqueArray;
    }
}
