<?php

namespace App\Services;

use App\Models\SystemSetting;

class GitBookJwtService
{
    private $headers;
    private $gitBookSecretForApi;
    private $gitBookSecretForHelp;

    /**
     * Constructor for the GitBookJwtService class.
     *
     * Initializes the headers and retrieves the GitBook secret values for the API and help guides.
     *
     * @return void
     */
    public function __construct()
    {
        $this->headers = [
            'alg' => 'HS256', // using algorithm
            'typ' => 'JWT', // JWT type
        ];
    }

    /**
     * Sets the GitBook secret values for the API and help guides by retrieving them from the SystemSetting model.
     *
     * @return void
     */
    public function setSystemSettings()
    {
        $this->gitBookSecretForApi = SystemSetting::where('slug', 'api_guide_authentication_token')->first()->value ?? '';
        $this->gitBookSecretForHelp = SystemSetting::where('slug', 'help_guide_authentication_token')->first()->value ?? '';
    }

    /**
     * Generate JWT using a payload.
     */
    public function generateJwtForGitBook($type)
    {
        $this->setSystemSettings();
        $headers = $this->encode(json_encode($this->headers)); // encode headers

        $payload["exp"] = time() + 3600; // add expiration to payload
        $payload = $this->encode(json_encode($payload)); // encode payload

        $gitBookSecret = ($type == 'api') ? $this->gitBookSecretForApi : $this->gitBookSecretForHelp;

        $signature = hash_hmac('SHA256', "$headers.$payload", $gitBookSecret, true); // create SHA256 signature
        $signature = $this->encode($signature); // encode signature

        return "$headers.$payload.$signature";
    }

    /**
     * Encode JWT using base64.
     *
     * @param string $str
     *
     * @return string
     */
    private function encode(string $str): string
    {
        return rtrim(strtr(base64_encode($str), '+/', '-_'), '='); // base64 encode string
    }
}
