<?php

namespace App\Services\Filter;

use App\Models\Asset;
use Illuminate\Support\Facades\DB;

class AssetValue
{
	/**
	 * Retrieve all assets with their actual original value.
	 *
	 * @return Collection
	 */
	public function all()
	{
		return Asset::select(DB::raw('(CASE WHEN assets.asset_original_value IS NULL THEN technical_specs.original_value ELSE assets.asset_original_value END) AS asset_value'))
            ->leftJoin('technical_specs', 'assets.technical_spec_id', '=', 'technical_specs.id')
			->whereNotNull(DB::raw('(CASE WHEN assets.asset_original_value IS NULL THEN technical_specs.original_value ELSE assets.asset_original_value END)')) // Exclude null values
    		->where(DB::raw('(CASE WHEN assets.asset_original_value IS NULL THEN technical_specs.original_value ELSE assets.asset_original_value END)'), '<>', 0) // Exclude zeros
			->groupBy('asset_value')
            ->get();
	}
}