<?php

namespace App\Services\Filter;

use App\Models\Asset;
use Illuminate\Support\Facades\DB;

class AssetDepreciationValue
{
	public function all()
	{
		return Asset::has('technicalSpec')
			->select(DB::raw('DISTINCT ROUND((CASE
				WHEN (FLOOR((DATEDIFF(NOW(), assets.created_at)) / 365)) > 0 THEN
					ROUND((COALESCE(assets.asset_original_value, technical_specs.original_value)) -
						(((COALESCE(assets.asset_original_value, technical_specs.original_value)) * 20) / 100) *
						(FLOOR((DATEDIFF(NOW(), assets.created_at)) / 365)), 2)
				ELSE
					(CASE WHEN assets.asset_original_value IS NULL THEN technical_specs.original_value ELSE assets.asset_original_value END)
				END)) AS depreciated_value'))
			->addSelect('assets.*')
			->leftJoin('technical_specs', 'assets.technical_spec_id', '=', 'technical_specs.id')
			->orderBy('depreciated_value')
			->groupBy('depreciated_value')
			->get();
	}
}
