<?php

namespace App\Services\DiscoveryTools\Zoom;

use App\Repositories\DiscoveryTools\ZoomRepository;

class ZoomService extends AbstractZoomService
{
    /**
     * Constructs a new instance of the ZoomService class.
     *
     * @param ZoomRepository $repository The repository instance used for accessing Zoom-related data.
     */
    public function __construct(protected ZoomRepository $repository) {}

    /**
     * Retrieve a collection of filtered Zoom fields from the database.
     *
     * The method filters Zoom fields based on the provided search term and type.
     * The result is a collection of key-value pairs, where the key is the field index
     * and the value is an array containing the 'id' and 'text' fields with the filtered value.
     *
     * @param string $search The search term to filter the fields by.
     * @param string $type The type of field to filter by.
     *
     * @return \Illuminate\Support\Collection The filtered collection of Zoom fields.
     */
    public function getFilterFields($search, $type)
    {
        $res = $this->repository->filterField($search, $type)->get();

        return $res->mapWithKeys(function ($item, $key) use ($type) {

            return [
                $key => [
                    'id' => $item[$type],
                    'text' => $item[$type],
                ]
            ];
        });
    }
}
