<?php

namespace App\Services\DiscoveryTools\Zoom;

use App\Repositories\DiscoveryTools\ZoomRepository;

class LocationDiscrepancy extends AbstractZoomService
{
    /**
     * Constructs a new instance of the LocationDiscrepancy service.
     *
     * @param  ZoomRepository  $repository
     */
    public function __construct(protected ZoomRepository $repository) {}

    /**
     * Making query for the report
     */
    public function data()
    {
        $assets     = $this->repository->getLocationDiscrepancy();
        $assets     = $this->filter($assets);
        $count      = $assets->count();
        $result     = $this->getOutputData($assets);

        return compact('result', 'count');
    }

    /**
     * Making the query for export
     */
    public function exportData()
    {
        $assets     = $this->repository->getLocationDiscrepancy();
        $assets     = $this->filter($assets);
        $assets     = $assets->orderBy('id', 'desc');

        return $assets;
    }
}
