<?php

namespace App\Services\DiscoveryTools\Zoom;

use App\Repositories\DiscoveryTools\ZoomRepository;

class DevicesOnHand extends AbstractZoomService
{
    /**
     * Constructor for DevicesOnHand service
     *
     * @param ZoomRepository $repository Instance of ZoomRepository.
     */
    public function __construct(protected ZoomRepository $repository) {}

    /**
     * Making query for the report
     */
    public function data()
    {
        $assets     = $this->repository->getDevicesOnHandCheckedIn();
        $assets     = $this->filter($assets);
        $count      = $assets->count();
        $result     = $this->getOutputData($assets);

        return compact('result', 'count');
    }

    /**
     * Exporting data for the report.
     */
    public function exportData()
    {
        $assets     = $this->repository->getDevicesOnHandCheckedIn();
        $assets     = $this->filter($assets);
        $assets     = $assets->orderBy('id', 'desc');

        return $assets;
    }
}
