<?php

namespace App\Services\DiscoveryTools\Zoom;

use App\Repositories\DiscoveryTools\ZoomRepository;
use Illuminate\Support\Str;

class DevicesNotCreated extends AbstractZoomService
{
    /**
     * Constructor for DevicesNotCreated service
     *
     * @param ZoomRepository $repository Instance of ZoomRepository
     */
    public function __construct(protected ZoomRepository $repository) {}

    /**
     * Making query for the report
     */
    public function data()
    {
        $assets     = $this->repository->getAssetsNotCreated();
        $assets     = $this->filter($assets);
        $count      = $assets->count();
        $result     = $this->getOutputData($assets);

        return compact('result', 'count');
    }

    /**
     * Exporting data for Devices Not Created report.
     */
    public function exportData()
    {
        $assets     = $this->repository->getAssetsNotCreated();
        $assets     = $this->filter($assets);
        $assets     = $assets->orderBy('id', 'desc');

        return $assets;
    }

    /**
     * Creating array for Data table data
     * @param $zoom Query Result
     * @param $index Starting index
     * @param $email route for user details
     *
     * @return array
     */
    public function getNestedData($zoom, $index)
    {
        $commonData = $this->getExportNestedData($zoom);

        foreach ($commonData as $key => $value) {
            $nestedData[Str::slug($key, '_')] = $value;
        }

        $zoomLocationLink = $zoom->location ? generateLocationLink($zoom->location->id, $zoom->room_name) : $zoom->room_name;

        $nestedData['id']   = $index;
        $nestedData['room_name_zoom'] = $zoomLocationLink;

        return $nestedData;
    }

    /**
     * Creating array for Zoom Devices Not Created report table data.
     * @param $asset Query Result
     *
     * @return array
     */
    public function getExportNestedData($asset)
    {
        $nestedData['Serial #']         = disableCSVInjection($asset->serial_no);
        $nestedData['Room Name (Zoom)'] = disableCSVInjection($asset->room_name);
        $nestedData['Site Code (Zoom)'] = disableCSVInjection($asset->site_code);
        $nestedData['Region (Zoom)']    = disableCSVInjection($asset->region);
        $nestedData['Device Type (Zoom)'] = disableCSVInjection($asset->device_type);
        $nestedData['Device System (Zoom)']    = disableCSVInjection($asset->device_system);
        $nestedData['Status (Zoom)']    = disableCSVInjection($asset->status);
        $nestedData['Host Name (Zoom)']        = disableCSVInjection($asset->hostname);
        $nestedData['Manufacturer (Zoom)']     = disableCSVInjection($asset->manufacturer);
        $nestedData['Make and Model (Zoom)']   = disableCSVInjection($asset->model);
        $nestedData['Firmware (Zoom)']         = disableCSVInjection($asset->firmware);
        $nestedData['App Version (Zoom)']      = disableCSVInjection($asset->app_version);
        $nestedData['IP Address (Zoom)']       = disableCSVInjection($asset->ip_address);
        $nestedData['MAC Addresses (Zoom)']      = disableCSVInjection($asset->mac_addresses);

        return $nestedData;
    }
}
