<?php

namespace App\Services\DiscoveryTools\Zoom;

use App\Repositories\DiscoveryTools\ZoomRepository;

class DevicesNotActive extends AbstractZoomService
{
    /**
     * Constructs a new instance of the DevicesNotActive service.
     *
     * @param  ZoomRepository  $repository
     */
    public function __construct(protected ZoomRepository $repository) {}

    /**
     * Making query for the report
     */
    public function data()
    {
        $assets     = $this->repository->getDevicesNotActive();
        $assets     = $this->filter($assets);
        $count      = $assets->count();
        $result     = $this->getOutputData($assets);

        return compact('result', 'count');
    }

    /**
     * Exporting data for Zoom Devices Not Active report.
     */
    public function exportData()
    {
        $assets     = $this->repository->getDevicesNotActive();
        $assets     = $this->filter($assets);
        $assets     = $assets->orderBy('id', 'desc');

        return $assets;
    }
}
