<?php

namespace App\Services\DiscoveryTools\Zoom;

use App\Repositories\DiscoveryTools\ZoomRepository;

class AllZoomService extends AbstractZoomService
{
    /**
     * Constructs a new instance of the AllZoomService class.
     *
     * @param ZoomRepository $repository The ZoomRepository instance used for database operations.
     */
    public function __construct(protected ZoomRepository $repository) {}

    /**
     * Making query for All Zoom report
     *
     * @return array
     */
    public function data()
    {
        $assets     = $this->repository->getAllDevices();
        $assets     = $this->filter($assets);
        $count      = $assets->count();
        $result     = $this->getOutputData($assets);

        return compact('result', 'count');
    }

    /**
     *  Export data for the report.
     *
     * @return Collection
     */
    public function exportData()
    {
        $assets     = $this->repository->getAllDevices();
        $assets     = $this->filter($assets);
        $assets     = $assets->orderBy('id', 'desc');

        return $assets;
    }
}
