<?php

namespace App\Services\DiscoveryTools\WorkspaceOne;

use App\Models\AirWatch;
use App\User;
use App\Models\Asset;
use App\Models\AssetStatus;
use App\Repositories\DiscoveryTools\WorkspaceOneRepository;

class MobileNumber extends AbstractWorkspaceOneService
{

    public function __construct(WorkspaceOneRepository $workspaceOneRepository)
    {
        $this->repository = $workspaceOneRepository;
    }

    /**
     * Making query for the report
     */
    public function data()
    {
        $inputData  = $this->getInputData();
        $assets     = $this->repository->getMobileNumberData();
        $assets     = $this->filterDevices($assets, $inputData);
        $count      = $assets->count();
        $assets = $this->getOutputData($assets, 'work_location');
        return compact('assets', 'count');
    }

    /**
     * Making the query for export
     */
    public function exportData()
    {
        $assets     = $this->repository->getMobileNumberData();
        $inputData  = $this->getExportInputData();
        $assets = $this->filterDevices($assets, $inputData);
        $assets     = $assets->orderBy('work_location', 'ASC');
        return $assets;
    }
}
