<?php

namespace App\Services\DiscoveryTools\WorkspaceOne;

use App\User;
use App\Models\Asset;
use App\Models\AssetStatus;
use App\Repositories\DiscoveryTools\WorkspaceOneRepository;

class CheckingInUserDiscrepancy extends AbstractWorkspaceOneService
{
    public function __construct(WorkspaceOneRepository $repository)
    {
        $this->repository = $repository;
    }

    /**
     * Making query for the report
     */
    public function data()
    {

        $inputData  = $this->getInputData();

        $assets     = $this->repository->getUserMismatchDevices();
        $assets     = $this->filterDevices($assets, $inputData);
        $count      = $assets->count();
        $assets     = $this->getOutputData($assets, 'created_at');

        return compact('assets', 'count');
    }

    /**
     * Making the query for export
     */
    public function exportData()
    {
        $assets     = $this->repository->getUserMismatchDevices();
        $inputData  = $this->getExportInputData();
        $assets = $this->filterDevices($assets, $inputData);
        $assets     = $assets->orderBy('created_at', 'desc');
        return $assets;
    }
}
