<?php

namespace App\Services\DiscoveryTools\WorkspaceOne;

use App\Repositories\DiscoveryTools\WorkspaceOneRepository;

class AllWorkspaceOneService extends AbstractWorkspaceOneService
{
    public function __construct(WorkspaceOneRepository $workspaceOneRepository)
    {
        $this->repository = $workspaceOneRepository;
    }

    /**
     * Making query for the report
     */

    public function data()
    {
        $inputData  = $this->getInputData();

        $assets     = $this->repository->getDevicesForAllReport();
        $assets     = $this->filterDevices($assets, $inputData);
        $count      = $assets->count();
        $assets     = $this->getOutputData($assets);

        return compact('assets', 'count');
    }

    /**
     * Making the query for export
     */
    public function exportData()
    {
        $assets     = $this->repository->getDevicesForAllReport();
        $inputData  = $this->getExportInputData();
        $assets = $this->filterDevices($assets, $inputData);
        $assets     = $assets->orderBy('created_at', 'desc');
        return $assets;
    }
}
