<?php

namespace App\Services\DiscoveryTools\MobileIron;

use App\Models\AssetStatus;
use App\Models\MobileIron;
use DB;

/**
 * Manages the common requirements in the reports like filters needed for reports ..etc
 */
class MobileIronService
{

    public function getFilterMobileIronFields($search, $type)
    {
        if ($type == 'userName') {
            $res = MobileIron::distinct('email')->select('email', 'first_name', 'last_name')
                ->where(function ($query) use ($search) {
                    $query->where('first_name', 'like', $search . '%')
                        ->orWhere('last_name', 'like', $search . '%')
                        ->orWhereRaw("CONCAT(`first_name`, ' ', `last_name`) like ?", [$search . '%'])
                        ->orWhere('email', 'like', $search . '%')
                        ->orWhere('display_name', 'like', $search . '%');
                })
                ->limit(15)->get();

            $result = $res->mapWithKeys(function ($item, $key) {
                return [
                    $key => [

                        'id' => $item->email,
                        'text' => $item->first_name . ' ' . $item->last_name . ' - ' . $item->email,
                    ]
                ];
            });
            return $result;
        }
        if ($type == 'mobile_iron_phone_number') {

            $res = MobileIron::distinct()->select("phone_number")->where("phone_number", 'like', '%' . $search . '%')->get();
            $result = $res->mapWithKeys(function ($item, $key) {
                return [
                    $key => [
                        'id' => $item['phone_number'],
                        'text' => $item['phone_number'],
                    ]
                ];
            });

            return $result;
        }

        $res = MobileIron::distinct()->select("$type")->where("$type", 'like', '%' . $search . '%')->get();
        $result = $res->mapWithKeys(function ($item, $key) use ($type) {
            return [
                $key => [
                    'id' => $item[$type],
                    'text' => $item[$type],
                ]
            ];
        });

        return $result;
    }
}
