<?php

namespace App\Services\DiscoveryTools\MobileIron;

use App\Repositories\DiscoveryTools\MobileIronRepository;

/**
 * Service Class for Devices On Hand Checking In
 */
class CheckingInOnHand  extends AbstractMobileIronService
{
    public function __construct(protected MobileIronRepository $repository)
    {
    }

    /**
     * Making query for the report
     */

    public function data()
    {
        $inputData  = $this->getInputData();
        $assets     = $this->repository->getDevicesOnHandCheckingIn();
        $assets     = $this->filter($assets, $inputData);

        $count         = $assets->count();

        $assets     = $this->getOutputData($assets);

        return compact('assets', 'count');
    }

    /**
     * Making the query for export
     */
    public function exportData()
    {
        $inputData  = $this->getExportInputData();
        $assets     = $this->repository->getDevicesOnHandCheckingIn();
        $assets     = $this->filter($assets, $inputData);

        $assets->orderBy('id', 'desc');

        return $assets;
    }
}
