<?php

namespace App\Services\DiscoveryTools\MobileIron;

use App\User;
use App\Models\Asset;
use App\Models\AssetStatus;
use App\Repositories\DiscoveryTools\MobileIronRepository;

class AllMobileIron extends AbstractMobileIronService
{

    public function __construct(protected MobileIronRepository $repository)
    {
    }

    /**
     * Making query for the report
     */

    public function data()
    {

        $inputData  = $this->getInputData();

        $assets     = $this->repository->getDevicesForAllReport();
        $assets     = $this->filter($assets, $inputData);
        $count      = $assets->count();
        $assets     = $this->getOutputData($assets);


        return compact('assets', 'count');
    }

    /**
     * Making the query for export
     */

    public function exportData()
    {
        $inputData  = $this->getExportInputData();

        $assets     = $this->repository->getDevicesForAllReport();
        $assets     = $this->filter($assets, $inputData);
        $assets     = $assets->orderBy('id', 'desc');

        return $assets;
    }
}
