<?php

namespace App\Services\DiscoveryTools\Kandji;

use App\Repositories\DiscoveryTools\KandjiRepository;
use App\User;

class NotCheckingInManaged extends AbstractKandjiService
{

    public function __construct(KandjiRepository $repository)
    {
        $this->repository = $repository;
    }

    /**
     * Making query for the report
     */
    public function data()
    {

        $inputData  = $this->getInputData();

        $assets     = $this->repository->getDevicesNotActive();
        $assets     = $this->filter($assets, $inputData);
        $count      = $assets->count();
        $assets     = $this->getOutputData($assets);

        return compact('assets', 'count');
    }

    /**
     * Making the query for export
     */
    public function exportData()
    {
        $inputData  = $this->getExportInputData();

        $assets     = $this->repository->getDevicesNotActive();
        $assets     = $this->filter($assets, $inputData);
        $assets     = $assets->orderBy('id', 'desc');

        return $assets;
    }
}
