<?php

namespace App\Services\DiscoveryTools\Kandji;

use App\User;

abstract class AbstractKandjiService
{
    abstract public function data();
    abstract public function exportData();

    /**
     * Taking the input data
     * @return Array
     */
    public function getInputData()
    {
        return [

            'serial_no'            => isset(request('form')['serial_no']) ? request('form')['serial_no'] : '',
            'mac_address'            => isset(request('form')['mac_address']) ? request('form')['mac_address'] : '',
            'model'                => isset(request('form')['model']) ? request('form')['model'] : '',
            'kandjiUser'        => isset(request('form')['kandji_user']) ? request('form')['kandji_user'] : '',
            'status'                  => isset(request('form')['user_status']) ? request('form')['user_status'] : '',
            'os_version'           => isset(request('form')['os_version']) ? request('form')['os_version'] : '',
            'lastConnectedFrom'  => isset(request('form')['last_connected_from']) ? request('form')['last_connected_from'] : '',
            'lastConnectedTo'    => isset(request('form')['last_connected_to']) ? request('form')['last_connected_to'] : '',
            'user_id'           => isset(request('form')['user']) ? request('form')['user'] : '',
            'asset_type_id'     => isset(request('form')['asset_type']) ? request('form')['asset_type'] : '',
            'manufacturer_id'   => isset(request('form')['manufacturer']) ? request('form')['manufacturer'] : '',
            'make_and_model_id' => isset(request('form')['teq_model']) ? request('form')['teq_model'] : '',
            'location_id'       => isset(request('form')['room_name']) ? request('form')['room_name'] : '',
            'asset_status_id'   => isset(request('form')['asset_status']) ? request('form')['asset_status'] : '',
            'platform'            => isset(request('form')['platform']) ? request('form')['platform'] : '',
            'teqtivity_asset'   => isset(request('form')['teqtivity_asset']) ? request('form')['teqtivity_asset'] : '',
            'userStatus_k'     => isset(request('form')['user_status_k']) ? request('form')['user_status_k'] : '',
            'userDepartment_k'     => isset(request('form')['user_department_k']) ? request('form')['user_department_k'] : '',
            'workLocation_k'   => isset(request('form')['work_location_k']) ? request('form')['work_location_k'] : '',
            'user_status'     => isset(request('form')['user_status']) ? request('form')['user_status'] : '',
            'user_department'     => isset(request('form')['user_department']) ? request('form')['user_department'] : '',
            'work_location'   => isset(request('form')['work_location']) ? request('form')['work_location'] : '',
            'host_name'      => isset(request('form')['host_name']) ? request('form')['host_name'] : '',
            'imei'      => isset(request('form')['imei']) ? request('form')['imei'] : '',
            'carrier'   => isset(request('form')['carrier']) ? request('form')['carrier'] : '',
            'carrier_country'   => isset(request('form')['carrier_country']) ? request('form')['carrier_country'] : '',
            'ram'      => isset(request('form')['ram']) ? request('form')['ram'] : '',
            'disk_capacity'   => isset(request('form')['disk_capacity']) ? request('form')['disk_capacity'] : '',

        ];
    }

    /**
     * Taking the filters for Mobile number export
     *
     * @return Array
     */
    public function getExportInputData()
    {
        return [

            'serial_no'           => request('serial_no') ?? '',
            'mac_address'           => request('mac_address') ?? '',
            'asset_type_id'       => request('asset_type') ?? '',
            'manufacturer_id'     => request('manufacturer') ?? '',
            'make_and_model_id'   => request('teq_model') ?? '',
            'model'               => request('model') ?? '',
            'user_id'             => request('user') ?? '',
            'kandjiUser'       => request('enrolled_user') ?? '',
            'status'              => (request('user_status') !== null)  ? request('user_status') : '',
            'os_version'          => request('os_version') ?? '',
            'lastConnectedFrom'  => request('last_connected_from') ?? '',
            'lastConnectedTo'    => request('last_connected_to') ?? '',
            'asset_status_id'     => request('asset_status') ?? '',
            'location_id'         => request('room_name') ?? '',
            'platform'            => request('platform') ?? '',
            'teqtivity_asset'   => request('teqtivity_asset') ?? '',
            'userStatus_k'     => request('user_status_k') ??  '',
            'workLocation_k'   => request('work_location_k') ??  '',
            'userDepartment_k'     => request('user_department_k') ?? '',
            'user_status'     => request('user_status') ??  '',
            'work_location'   => request('work_location') ??  '',
            'user_department'     => request('user_department') ?? '',
            'imei'      => request('imei') ??  '',
            'host_name'      => request('host_name') ??  '',
            'ram'      => request('ram') ??  '',
            'disk_capacity'      => request('disk_capacity') ??  '',
            'carrier'   => request('carrier') ?? '',
            'carrier_country'   => request('carrier_country') ?? '',
        ];
    }

    /**
     * Filer the results based on filters
     * 
     * @param $assets DB Query
     * @param Array $inputData   Filter data
     * 
     * @return Query
     */
    public function filter($assets, $inputData)
    {
        $assets     = $assets->RelationData($inputData['serial_no'], 'kandji_devices.serial_no');
        $assets     = $assets->RelationData($inputData['model'], 'kandji_devices.model');
        $assets     = $assets->RelationData($inputData['kandjiUser'], 'kandji_devices.email');
        $assets     = $assets->RelationData($inputData['ram'], 'kandji_devices.ram');
        $assets     = $assets->RelationData($inputData['disk_capacity'], 'kandji_devices.disk_capacity');


        $assets     = $this->repository->filterWithAssetMakeAndModelFields($assets, 'manufacturer_id', $inputData['manufacturer_id']);

        $assets     = $this->repository->filterWithAssetFields($assets, 'user_id', $inputData['user_id']);
        $assets     = $this->repository->filterWithAssetFields($assets, 'asset_type_id', $inputData['asset_type_id']);
        $assets     = $this->repository->filterWithAssetFields($assets, 'make_and_model_id', $inputData['make_and_model_id']);
        $assets     = $this->repository->filterWithAssetFields($assets, 'location_id', $inputData['location_id']);
        $assets     = $this->repository->filterWithAssetFields($assets, 'asset_status_id', $inputData['asset_status_id']);

        $assets     = $this->repository->filterWithUserFields($assets, 'status', $inputData['status']);

        $assets     = $this->repository->filterWithUserFields($assets, 'status', $inputData['userStatus_k']);
        $assets     = $this->repository->filterWithUserFields($assets, 'city', $inputData['workLocation_k']);
        $assets     = $this->repository->filterWithUserFields($assets, 'department_id', $inputData['userDepartment_k']);

        $assets     = $this->repository->filterWithTeqtivityUserFields($assets, 'department_id', $inputData['user_department']);
        $assets     = $this->repository->filterWithTeqtivityUserFields($assets, 'status', $inputData['user_status']);
        $assets     = $this->repository->filterWithTeqtivityUserFields($assets, 'city', $inputData['work_location']);

        $assets     = $this->repository->filterWithLastCheckIn($assets, $inputData['lastConnectedFrom'], $inputData['lastConnectedTo']);

        $assets     = $this->repository->filterTeqtivityAssetOrNot($assets, $inputData['teqtivity_asset']);

        return $assets;
    }

    /**
     * Generating data table data from qurey result
     * @param $users Query Result
     * @param $start Starting index
     * @param $data Collection valriable that will return
     *
     * @return array
     */
    public function getReportData($users, $start, $data)
    {
        $parentIndex = $start;

        foreach ($users as $key => $user) {
            $parentIndex++;

            $nestedData = $this->getNestedData($user, $parentIndex);
            $data[] = $nestedData;
        }

        return $data;
    }

    /**
     * Generating data to export
     * @param $assets Query Result
     * @param $start Starting index
     * @param $data Collection valriable that will return
     * @param $requiredColumns colums to be shown in export file

     * @return array
     */
    public function getReportExportData($assets, $start, $data, $requiredColumns)
    {
        $parentIndex = $start;

        foreach ($assets as $key => $asset) {
            $parentIndex++;
            $nestedData = $this->getExportNestedData($asset, $parentIndex, $requiredColumns);
            $data[] = $nestedData;
        }
        return $data;
    }


    /**
     * Creating array for Data table data
     * @param $asset Query Result
     * @param $index Starting index
     * @param $email route for user details
     *
     * @return array
     */
    public function getNestedData($asset, $index)
    {
        $assetLink          = $asset->asset ? route('assets.show', $asset->asset->id) : 'javascript:void(0)';

        $userLink           = $asset->user_id ? route('users.show', $asset->user_id) : 'javascript:void(0)';

        $teqtivityUserLink   = isset($asset->asset) ? ($asset->asset->user_id ? route('users.show', $asset->asset->user_id) : 'javascript:void(0)') : '';
        $teqtivityUser = isset($asset->asset) ? ($asset->asset->user_id ? ("<a href=$teqtivityUserLink>" . $asset->asset->user->first_name . ' - ' . $asset->asset->user->email . "</a>") : '') : '';

        $nestedData['id']           = $index;
        $nestedData['serial_no']        = $asset->asset ? "<a href=$assetLink>$asset->serial_no</a>" : $asset->serial_no;
        $nestedData['computer_name'] = $asset->name;
        $nestedData['ram']        = $asset->ram;
        $nestedData['disk_capacity'] = $asset->disk_capacity;
        $nestedData['asset_type'] = optional(optional($asset->asset)->assetType)->name;

        $nestedData['manufacturer_teqtivity']     = optional(optional(optional($asset->asset)->makeAndModel)->manufacturer)->name;
        $nestedData['hardware_teqtivity']            = optional(optional($asset->asset)->makeAndModel)->name;
        $nestedData['teqtivity_asset'] = $asset->asset_id ? 'Yes' : 'No';
        $nestedData['location_teqtivity']     = optional(optional($asset->asset)->location)->room_name;
        $nestedData['asset_status_teqtivity']     = $asset->asset ? optional($asset->asset->assetStatus)->name : '';


        $nestedData['kandji_user']  = $asset->user_id ? "<a href=$userLink>" . $asset->email . "</a>" : $asset->email;;
        $nestedData['kandji_user_status']  = isset($asset->user) ? (optional($asset->user)->status == 1 ? 'Active' : 'Terminated') : '';
        $nestedData['kandji_user_department']  = optional(optional($asset->user)->department)->name;
        $nestedData['kandji_user_work_location']  = optional($asset->user)->city;


        $nestedData['teqtivity_user']   = $teqtivityUser;
        $nestedData['teqtivity_user_status']  = isset($asset->asset->user) ? (optional(optional($asset->asset)->user)->status == 1 ? 'Active' : 'Terminated') : '';
        $nestedData['teqtivity_user_department']  = optional(optional(optional($asset->asset)->user)->department)->name;
        $nestedData['teqtivity_user_work_location']  = optional(optional($asset->asset)->user)->city;


        $nestedData['last_connected'] = $asset->last_checkin;
        $nestedData['os_version']   = $asset->os_version;
        $nestedData['hardware']   = $asset->model;
        $nestedData['mac_address']   = '';


        $nestedData['imei']             = '';
        $nestedData['last_modified_date']   = (($asset->asset) && ($asset->asset->latestAssetHistory)) ?  $asset->asset->latestAssetHistory->updated_at : (($asset->latestAssetHistory) ?  $asset->latestAssetHistory->updated_at : '');
        $nestedData['platform']    = $asset->platform;
        $nestedData['update_asset']     = $this->getUpdateAssetButton($asset->asset, optional($asset->asset)->assetStatus);
        $nestedData['create_asset']     = $this->getCreateAssetButton($asset);

        return $nestedData;
    }

    /**
     * Creating array for export data
     * @param $asset Query Result
     * @param $index Starting index
     * @param $requiredColumns columns to be added in export file
     * @return array
     */
    public function getExportNestedData($asset, $index, $requiredColumns)
    {

        $nestedData['Serial # (Kandji)']                 = $asset->serial_no;
        $nestedData['Asset Type (Teqtivity)'] = optional(optional($asset->asset)->assetType)->name;
        $nestedData['Computer Name']            = $asset->name;
        $nestedData['OS Platform']               = $asset->platform;
        $nestedData['OS Version']               = $asset->os_version;
        $nestedData['Last Check In']            = $asset->checkin_date;
        $nestedData['Last Modified Date']       = (($asset->asset) && ($asset->asset->latestAssetHistory)) ?  $asset->asset->latestAssetHistory->updated_at : (($asset->latestAssetHistory) ?  $asset->latestAssetHistory->updated_at : '');

        $nestedData['Manufacturer (Teqtivity)'] = optional(optional(optional($asset->asset)->makeAndModel)->manufacturer)->name;
        $nestedData['Hardware Standard (Teqtivity)'] = optional(optional($asset->asset)->makeAndModel)->name;
        $nestedData['Asset Location (Teqtivity)'] = optional(optional($asset->asset)->location)->room_name;
        $nestedData['Asset Status (Teqtivity)'] = $asset->asset ? optional($asset->asset->AssetStatus)->name : '';

        $nestedData['User (Kandji)'] = optional($asset->user)->email;
        $nestedData['User Status (Kandji)'] = isset($asset->user) ? (optional($asset->user)->status == 1 ? 'Active' : 'Terminated') : '';
        $nestedData['User Department (Kandji)'] = optional(optional($asset->user)->department)->name;
        $nestedData['User Work Location (Kandji)'] = optional($asset->user)->city;

        $nestedData['User (Teqtivity)'] = optional(optional($asset->asset)->user)->first_name . ' - ' . optional(optional($asset->asset)->user)->email;
        $nestedData['User Status (Teqtivity)'] = isset($asset->asset->user) ? (optional(optional($asset->asset)->user)->status == 1 ? 'Active' : 'Terminated') : '';
        $nestedData['User Department (Teqtivity)'] =  optional(optional(optional($asset->asset)->user)->department)->name;
        $nestedData['User Work Location (Teqtivity)'] =  optional(optional($asset->asset)->user)->city;

        $nestedData['Hardware Standard (Kandji)'] = $asset->model;
        $nestedData['Last Seen'] = $asset->last_checkin;


        foreach ($requiredColumns as $column) {
            $data[$column] =  $nestedData[$column];
        }

        return $data;
    }

    /**
     * Executing the query
     * @param $users Query
     * @return Query Result
     */
    public function getOutputData($assets)
    {
        $start = request('start');
        $limit = request('length');
        if ($limit != -1) {
            $assets = $assets->skip($start)
                ->take($limit);
        }

        $assets = $assets->orderBy('id', 'desc');
        return $assets->get();
    }

    /**
     * Set up Create Asset Button
     * @param mixed $asset
     */
    public function getCreateAssetButton($asset)
    {
        if (auth()->user()->can('IT Assets Edit') && $asset) {
            return '<a href="javascript:;" data-asset="' . $asset->id . '" data-asset-serial="' . $asset->serial_no . '" class="btn btn-primary btn-sm create-asset">Create Asset</a>';
        }
        return '';
    }

    /**
     * Generates the update asset button HTML based on the asset and asset status.
     *
     * @param object $asset The asset object.
     * @param string $assetStatus The asset status.
     * @return string The HTML for the update asset button.
     */
    public function getUpdateAssetButton($asset, $assetStatus)
    {
        if (auth()->user()->can('IT Assets Edit') && $asset) {
            return '<a href="javascript:;" data-asset="' . $asset->id . '" data-asset-serial="' . $asset->serial_no . '" data-asset-current-status="' . optional($assetStatus)->slug . '" data-parent-asset="' . $asset->parent_asset_id . '" class="btn btn-primary btn-sm update-discrepancy-asset">Update Asset</a>';
        }
        return '';
    }
}
