<?php

namespace App\Services\DiscoveryTools\JumpCloud;


class NotCheckingInNotManagedService extends AbstractJumpCloudService
{

    /**
     * Making query for the report
     */
    public function data()
    {
        $assets     = $this->repository->getNotManaged();
        $assets     = $this->filter($assets);
        $count      = $assets->count();
        $assets     = $this->reportOutputData->getOutputData($assets);

        return compact('assets', 'count');
    }

    /**
     * Making the query for export
     */
    public function exportData()
    {
        $assets     = $this->repository->getNotManaged();
        $assets     = $this->filter($assets);
        $assets     = $assets->orderBy('id', 'desc');

        return $assets;
    }

    /**
     * Filer the results based on filters
     * 
     * @param $assets DB Query
     * @param Array $inputData   Filter data
     * 
     * @return Query
     */
    public function filter($assets)
    {

        $inputData  = $this->getInputData();
        $assets     = $this->repository->filterByMakeAndModelFields($assets, 'manufacturer_id', $inputData['manufacturer_teq']);

        $assets     = $this->repository->filterByAssetFields($assets, 'serial_no', $inputData['serial_no']);
        $assets     = $this->repository->filterByAssetFields($assets, 'user_id', $inputData['teq_user']);
        $assets     = $this->repository->filterByAssetFields($assets, 'asset_type_id', $inputData['asset_type']);
        $assets     = $this->repository->filterByAssetFields($assets, 'make_and_model_id', $inputData['make_and_model']);
        $assets     = $this->repository->filterByAssetFields($assets, 'location_id', $inputData['location']);
        $assets     = $this->repository->filterByAssetFields($assets, 'asset_status_id', $inputData['asset_status']);
        $assets     = $this->repository->filterByAssetFields($assets, 'host_name', $inputData['host_name']);
        $assets     = $this->repository->filterByAssetFields($assets, 'mac', $inputData['mac_address']);
        $assets     = $this->repository->filterByAssetFields($assets, 'imei', $inputData['imei']);
        $assets     = $this->repository->filterByAssetFields($assets, 'carrier_id', $inputData['carrier']);
        $assets     = $this->repository->filterWithCarrierCountry($assets, $inputData['carrier_country'], 'carrier');
        $assets     = $this->repository->filterWithUserFields($assets, 'status', $inputData['user_status']);
        $assets     = $this->repository->filterWithUserFields($assets, 'department_id', $inputData['user_department']);
        $assets     = $this->repository->filterWithUserFields($assets, 'city', $inputData['work_location']);


        $assets     = $this->repository->filterWithLastModifiedDate($assets, $inputData['last_seen_from'], $inputData['last_seen_to']);

        return $assets;
    }


    /**
     * Get common nested data for both report and export.
     * 
     * @param mixed $asset
     * 
     * @return array
     */
    public function getCommonNestedData($asset)
    {
        $nestedData = [];

        $nestedData = array_merge_recursive(
            $nestedData,
            $this->getTeqtivityData($asset),
            $this->getTeqtivityUserData($asset),
            $this->getTeqtivitySystemData($asset)
        );

        return $nestedData;
    }


    /**
     * Get teqtivity system data for report and export.
     *
     * @param mixed $asset
     *
     * @return array
     */
    public function getTeqtivitySystemData($asset)
    {
        $nestedData = [];

        $nestedData['report']['host_name_teqtivity']        = $nestedData['export']['Host Name (Teqtivity)'] =  $asset->host_name;
        $nestedData['report']['mac_address_teqtivity']      = $nestedData['export']['MAC Address (Teqtivity)'] =  $asset->mac;
        $nestedData['report']['imei_teqtivity']             = $nestedData['export']['IMEI (Teqtivity)'] =  $asset->imei;
        $nestedData['report']['carrier']                    = $nestedData['export']['Carrier (Teqtivity)'] =  optional($asset->carrier)->name;
        $nestedData['report']['carrier_country']            = $nestedData['export']['Carrier Country (Teqtivity)'] =  optional(optional($asset->carrier)->country)->name;
        $nestedData['report']['last_modified_date']         = $nestedData['export']['Last Seen'] =  optional($asset)->latestAssetHistory ? optional(optional($asset)->latestAssetHistory)->updated_at : '';

        return $nestedData;
    }


    /**
     * Creating array for Data table data
     * @param $asset Query Result
     * @param $index Starting index
     * @param $email route for user details
     *
     * @return array
     */
    public function getNestedData($asset, $index)
    {
        $assetLink  = $asset ? route('assets.show', $asset->id) : 'javascript:void(0)';
        $teqtivityUser      = optional($asset->user);
        $teqtivityUserLink  = $teqtivityUser ? route('users.show', optional($teqtivityUser)->id ?: 0) : 'javascript:void(0)';
        $serialNo  = $asset ? ("<a href=$assetLink>" . $asset->serial_no . "</a>") : $asset->serial_no;

        $nestedData = $this->getCommonNestedData($asset)['report'];
        $nestedData['id']               = $index;
        $nestedData['serial_no']        = $serialNo;
        $nestedData['teq_user']   = $teqtivityUser ? ("<a href=$teqtivityUserLink>" . $teqtivityUser->first_name . ' - ' . $teqtivityUser->email . "</a>") : '';


        return $nestedData;
    }

    /**
     * Creating array for export data
     * @param $asset Query Result
     * @param $index Starting index
     *
     * @return array
     */
    public function getExportNestedData($asset, $index)
    {
        $nestedData = $this->getCommonNestedData($asset)['export'];

        return $nestedData;
    }
}
