<?php

namespace App\Services\DiscoveryTools\JumpCloud;

use App\Repositories\DiscoveryTools\JumpCloudRepository;

class JumpCloudService
{
    /**
     * Class constructor.
     *
     * @param JumpCloudRepository $repository The JumpCloud repository instance.
     */
    public function __construct(protected JumpCloudRepository $repository) {}

    /**
     * Retrieves the filter fields based on the provided search and type.
     *
     * @param mixed $search The search term used to filter the fields.
     * @param mixed $type The type of field to filter.
     * @return mixed The result set containing the filtered fields.
     */

    public function getFilterFields($search, $type)
    {
        $res = $this->repository->filterField($search, $type);

        return $res;
    }
}
