<?php

namespace App\Services\DiscoveryTools\Jamf;

use App\User;
use App\Models\Asset;
use App\Models\AssetStatus;
use App\Repositories\DiscoveryTools\JamfRepository;
use App\Services\DiscoveryTools\Jamf\AbstractJamfService;

class PreStageDevicesService extends AbstractJamfService
{
    public function __construct(protected JamfRepository $repository)
    {
    }

    /**
     * filter for All jamf report
     */
    public function data()
    {
        $assets = $this->repository->getPreStageDevices();
        $inputData  = $this->getInputData();
        $assets = $this->filterDevices($assets, $inputData);
        $count = $assets->count();
        $assets = $this->getOutputData($assets, 'id');

        return compact('count', 'assets');
    }

    /**
     * Making the query for export
     */
    public function exportData()
    {
        $assets     = $this->repository->getPreStageDevices();
        $inputData  = $this->getExportInputData();
        $assets = $this->filterDevices($assets, $inputData);
        $assets     = $assets->orderBy('id', 'desc');
        return $assets;
    }
}
