<?php

namespace App\Services\DiscoveryTools\Jamf;

use App\Repositories\DiscoveryTools\JamfRepository;
use App\User;

class NotCheckingInManaged extends AbstractJamfService
{

    public function __construct(JamfRepository $repository)
    {
        $this->repository = $repository;
    }

    /**
     * Making query for the report
     */
    public function data()
    {

        $inputData  = $this->getInputData();
        $assets     = $this->repository->getDevicesNotActive();
        $assets     = $this->filterDevices($assets, $inputData);
        $count      = $assets->count();
        $assets = $this->getOutputData($assets, 'checkin_date');
        return compact('assets', 'count');
    }

    /**
     * Making the query for export
     */
    public function exportData()
    {
        $assets     = $this->repository->getDevicesNotActive();
        $inputData  = $this->getExportInputData();
        $assets = $this->filterDevices($assets, $inputData);
        $assets     = $assets->orderBy('checkin_date', 'desc');
        return $assets;
    }
}
