<?php

namespace App\Services\DiscoveryTools\Jamf;

use App\Repositories\DiscoveryTools\JamfRepository;

/**
 * Class used for general puposes of jamf including filter fields population ..etc 
 */
class JamfService
{
    protected $repository;

    public function __construct(JamfRepository $jamfRepository)
    {
        $this->repository = $jamfRepository;
    }

    /**
     * Populate search fields
     * @param mixed $search
     * @param mixed $type
     * 
     * @return [type]
     */
    public function getFilterFields($search, $type)
    {
        $res = $this->repository->filterField($search, $type)->get();

        $result = $res->mapWithKeys(function ($item, $key) use ($type) {
            if ($type == 'model') {
                return [
                    $key => [
                        'id' => $item['model'],
                        'text' => $item['manufacturer'] . ' ' . $item['model'],
                    ]
                ];
            }

            return [
                $key => [
                    'id' => $item[$type],
                    'text' => $item[$type],
                ]
            ];
        });

        return $result;
    }
}
