<?php

namespace App\Services\DiscoveryTools\Jamf;

use App\User;
use App\Models\Asset;
use App\Models\AssetStatus;
use App\Repositories\DiscoveryTools\JamfRepository;
use App\Services\DiscoveryTools\Jamf\AbstractJamfService;

class AllJamfService extends AbstractJamfService
{
    public function __construct(JamfRepository $repository)
    {
        $this->repository = $repository;
    }

    /**
     * filter for All jamf report
     */
    public function data()
    {
        $assets = $this->repository->getAllJamfDevices();
        $inputData  = $this->getInputData();
        $assets = $this->filterDevices($assets, $inputData);
        $count = $assets->count();
        $assets = $this->getOutputData($assets, 'checkin_date');

        return compact('count', 'assets');
    }

    /**
     * Making the query for export
     */
    public function exportData()
    {
        $assets     = $this->repository->getAllJamfDevices();
        $inputData  = $this->getExportInputData();
        $assets = $this->filterDevices($assets, $inputData);
        $assets     = $assets->orderBy('checkin_date', 'desc');
        return $assets;
    }
}
