<?php

namespace App\Services\DiscoveryTools\Intune;

use App\Repositories\DiscoveryTools\IntuneRepository;
use App\User;

class NotCheckingInManaged extends AbstractIntuneService
{

    public function __construct(protected IntuneRepository $intuneRepository)
    {
    }

    /**
     * Making query for the report
     */
    public function data()
    {

        $inputData  = $this->getInputData();
        $assets     = $this->intuneRepository->getDevicesNotActive();
        $assets     = $this->filterDevices($assets, $inputData);
        $count      = $assets->count();
        $assets = $this->getOutputData($assets, 'checkin_date');
        return compact('assets', 'count');
    }

    /**
     * Making the query for export
     */
    public function exportData()
    {
        $assets     = $this->intuneRepository->getDevicesNotActive();
        $inputData  = $this->getExportInputData();
        $assets = $this->filterDevices($assets, $inputData);
        $assets     = $assets->orderBy('checkin_date', 'desc');
        return $assets;
    }
}
