<?php

namespace App\Services\DiscoveryTools\Intune;

use App\User;
use App\Models\Asset;
use App\Models\AssetStatus;
use App\Repositories\DiscoveryTools\IntuneRepository;

class AllIntuneService extends AbstractIntuneService
{
    public function __construct(protected IntuneRepository $intuneRepository)
    {
    }

    /**
     * Making query for the report
     */
    public function data()
    {
        $assets = $this->intuneRepository->getAllIntuneDevices();
        $inputData = $this->getInputData();
        $assets = $this->filterDevices($assets, $inputData);
        $count = $assets->count();
        $assets = $this->getOutputData($assets, 'checkin_date');

        return compact('count', 'assets');
    }

    /**
     * Making the query for export
     */
    public function exportData()
    {
        $assets     = $this->intuneRepository->getAllIntuneDevices();
        $inputData  = $this->getExportInputData();
        $assets = $this->filterDevices($assets, $inputData);
        $assets     = $assets->orderBy('checkin_date', 'desc');
        return $assets;
    }

    public function getFilterFields($search, $type)
    {
        $res = $this->intuneRepository->filterField($search, $type)->get();

        $result = $res->mapWithKeys(function ($item, $key) use ($type) {
            if ($type == 'model') {
                return [
                    $key => [
                        'id' => $item['model'],
                        'text' => $item['manufacturer'] . ' ' . $item['model'],
                    ]
                ];
            }

            return [
                $key => [
                    'id' => $item[$type],
                    'text' => $item[$type],
                ]
            ];
        });

        return $result;
    }
}
