<?php

namespace App\Services\DiscoveryTools\Chromebook;

use App\Repositories\DiscoveryTools\ChromebookRepository;

class NotCheckingInManaged extends AbstractChromebookService
{

    public function __construct(ChromebookRepository $chromebookRepository)
    {
        $this->repository = $chromebookRepository;
    }

    /**
     * Making query for the report
     */

    public function data()
    {
        $assets = [];
        $inputData  = $this->getInputData();
        $assets     = $this->repository->getInactiveDevices();
        $assets = $this->filter($assets, $inputData);

        $count = $assets->count();
        $assets = $this->getOutputData($assets);
        return compact('assets', 'count');
    }

    /**
     * Making the query for export
     */
    public function exportData()
    {
        $inputData  = $this->getExportInputData();
        $assets     = $this->repository->getInactiveDevices();
        $assets     = $this->filter($assets, $inputData);

        $assets->orderBy('id', 'ASC');
        return $assets;
    }
}
