<?php

namespace App\Services\DiscoveryTools\Chromebook;

use App\Repositories\DiscoveryTools\ChromebookRepository;

class AllChromeBook extends AbstractChromebookService
{

    public function __construct(ChromebookRepository $chromebookRepository)
    {
        $this->repository = $chromebookRepository;
    }

    /**
     * Making query for the report
     */

    public function data()
    {

        $inputData  = $this->getInputData();

        $assets     = $this->repository->getDevicesForAllReport();
        $assets     = $this->filter($assets, $inputData);
        $count      = $assets->count();
        $assets     = $this->getOutputData($assets);


        return compact('assets', 'count');
    }

    /**
     * Making the query for export
     */

    public function exportData()
    {
        $inputData  = $this->getExportInputData();

        $assets     = $this->repository->getDevicesForAllReport();
        $assets     = $this->filter($assets, $inputData);
        $assets     = $assets->orderBy('id', 'desc');

        return $assets;
    }
}
