<?php

namespace App\Services\DiscoveryTools;

abstract class AbstractService
{
    /**
     * Executing the query
     * @param $devices Query
     * @return Query Result
     */
    public function getOutputData($devices, $order)
    {
        $start = request('start');
        $limit = request('length');
        if ($limit != -1) {
            $devices = $devices->offset($start)->limit($limit);
        }
        $devices->orderBy($order, 'DESC');

        return $devices->get();
    }

    /**
     * Generating data table data from qurey result
     * @param $users Query Result
     * @param $start Starting index
     * @param $data Collection valriable that will return
     *
     * @return array
     */
    public function getReportData($assets, $start, $data = [])
    {
        $parentIndex = $start;

        foreach ($assets as $key => $asset) {
            $parentIndex++;
            $userLink = $asset->user_id ? route('users.show', $asset->user_id) : '#';
            $nestedData = $this->getNestedData($asset, $parentIndex, $userLink);
            $data[] = $nestedData;
        }

        return $data;
    }

    /**
     * Taking the input data
     * @return Array
     */
    public function getInputData()
    {
        return [
            'serial_no'            => isset(request('form')['serial_no']) ? request('form')['serial_no'] : '',
            'model'                => isset(request('form')['model']) ? request('form')['model'] : '',
            'enrolled_user'        => isset(request('form')['enrolled_user']) ? request('form')['enrolled_user'] : '',
            'status'                  => isset(request('form')['user_status']) ? request('form')['user_status'] : '',
            'os_version'           => isset(request('form')['os_version']) ? request('form')['os_version'] : '',
            'checkin_date_from'    => isset(request('form')['check_in_from']) ? request('form')['check_in_from'] : '',
            'checkin_date_to'   => isset(request('form')['check_in_to']) ? request('form')['check_in_to'] : '',
            'location'            => isset(request('form')['work_location']) ? request('form')['work_location'] : '',
            'user_id'           => isset(request('form')['user']) ? request('form')['user'] : '',
            'asset_type_id'     => isset(request('form')['asset_type']) ? request('form')['asset_type'] : '',
            'manufacturer_id'   => isset(request('form')['manufacturer']) ? request('form')['manufacturer'] : '',
            'make_and_model_id' => isset(request('form')['teq_model']) ? request('form')['teq_model'] : '',
            'location_id'       => isset(request('form')['room_name']) ? request('form')['room_name'] : '',
            'asset_status_id'   => isset(request('form')['asset_status']) ? request('form')['asset_status'] : '',
        ];
    }
}
