<?php

namespace App\Services\Dashboard;

use App\Models\Asset;
use Carbon\Carbon;
use Facades\App\Repositories\Reports\DuplicateAssetsRepository;

class InventoryDashboardService
{
    protected $settings;
    protected $repository;
    protected $appleRepository;
    protected $androidRepository;
    protected $chromeRepository;
    protected $windowsRepository;
    public function __construct()
    {
        $repositoryName = "\App\Repositories\OsCompliance\\" . config('os-compliance.apple_os.repository');
        $this->appleRepository = new $repositoryName;

        $androidRepositoryName = "\App\Repositories\OsCompliance\\" . config('os-compliance.android_os.repository');
        $this->androidRepository = new $androidRepositoryName;

        $chromeRepositoryName = "\App\Repositories\OsCompliance\\" . config('os-compliance.chrome_os.repository');
        $this->chromeRepository = new $chromeRepositoryName;

        $windowsRepositoryName = "\App\Repositories\OsCompliance\\" . config('os-compliance.windows_os.repository');
        $this->windowsRepository = new $windowsRepositoryName;
    }

    /**
     * Get assets with expired warranty end date
     */
    public function expiredWarrantyEndDate()
    {
        return Asset::whereDate('warranty_end_date', '<', Carbon::today()->toDateString());
    }

    /**
     * Get assets with duplicate serial #
     */
    public function duplicateSerialno()
    {
        return DuplicateAssetsRepository::getAssetsListWithMatchingSerialNumber()->count();
    }

    /**
     * Get assets with duplicate tag
     */
    public function duplicateTag()
    {
        return DuplicateAssetsRepository::getAssetsListWithMatchingAssetTag()->count();
    }

    /**
     * Get assets with outdated os version
     */
    public function outdatedOSVersion()
    {
        $appleDeviceCount       = $this->appleRepository->getAppleDevicesWithOutdatedOS()->count();
        $androidDeviceCount     = $this->androidRepository->getAndroidDevicesWithOutdatedOS()->count();
        $appleMobileDeviceCount = $this->appleRepository->getAppleMobileDevicesWithOutdatedOS()->count();
        $chromeDeviceCount      = $this->chromeRepository->getDevicesWithOutdatedOsFromChrome()->count();
        $windowsDeviceCount      = $this->windowsRepository->getDevicesWithOutdatedOSFromIntune()->count();
        $total = $windowsDeviceCount + $appleDeviceCount + $chromeDeviceCount + $androidDeviceCount + $appleMobileDeviceCount;
        return $total;
    }

    /**
     * Get assets missing Purchase Order information
     * @return [type]
     */
    public function missingPurchaseOrder()
    {
        return Asset::where(function ($query) {
            return $query->whereNull('po_id')
                ->orWhere('po_id', '');
        });
    }

    /**
     * Get assets missing vendor information
     * @return [type]
     */
    public function missingVendor()
    {
        return Asset::whereNull('vendor_id');
    }
}
