<?php

namespace App\Services\Dashboard;

use Facades\App\Repositories\Dashboard\ComplianceDashboardRepository;

class ComplianceDashboard
{
    /**
     * For getting compliance dashboard data
     *
     * @return data
     */
    public function complianceDashboardData($widgetName)
    {
        $types = ["laptop" => 'Laptops', "desktop" => 'Desktops', 'chromebooks' => 'Chromebooks', "tablet" => 'Tablets', "mobile_phone" => 'Mobiles'];
        foreach ($types as $type => $value) {
            if ($widgetName == 'Lost/Stolen, not Locked') {
                $WidgetData[$value] = $this->getLostOrStolenNotLockedCount($type);
            } else if ($widgetName == 'EOL Wiped without CODD') {
                $WidgetData[$value] = $this->getEOLWipedWithoutCODDCount($type);
            } else if ($widgetName == 'Not in MDM') {
                $WidgetData[$value] = $this->getNotInMDMCount($type);
            } else if ($widgetName == "Sensor Detected") {
                $WidgetData[$value] = $this->getSensorDetectedAssetsCount($type);
            }
        }

        return $WidgetData;
    }
    /**
     * For getting lost or stolen staus with not locked assets count
     *
     * @return data
     */
    function  getLostOrStolenNotLockedCount($type)
    {
        if ($type != 'chromebooks') {
            return ComplianceDashboardRepository::getLostOrStolenNotLockedCount($type);
        }
        return ComplianceDashboardRepository::getLostOrStolenNotLockedChromebooksCount();
    }
    /**
     * For getting count of eol wiped and without certificate assets count
     *
     * @return data
     */
    function  getEOLWipedWithoutCODDCount($type)
    {
        if ($type != 'chromebooks') {
            return ComplianceDashboardRepository::getEOLWipedWithoutCODDCount($type);
        }
        return ComplianceDashboardRepository::getEOLWipedWithoutCODDChromebooksCount();
    }
    /**
     * For getting count of not in mdm assets
     *
     * @return data
     */
    function  getNotInMDMCount($type)
    {
        if ($type != 'chromebooks') {
            return ComplianceDashboardRepository::getNotInMDMCount($type);
        }
        return ComplianceDashboardRepository::getNotInMDMChromebooksCount();
    }
    /**
     * For getting count of eol wiped checking in assets 
     *
     * @return data
     */
    public function getEOLWipedCheckingInData()
    {
        $data = ComplianceDashboardRepository::getEOLWipedCheckingInData();
        $WidgetData = [];
        foreach ($data as $key => $type) {
            $WidgetData[$type->type] = $type->count ? $type->count : 0;
        }
        if (!$WidgetData) { // Before running query to insert data to eol_wiped_checking_in_assets_count table whole values are set to zero 
            $WidgetData['Laptops'] = 0;
            $WidgetData['Desktops'] = 0;
            $WidgetData['Chromebooks'] = 0;
            $WidgetData['Tablets'] = 0;
            $WidgetData['Mobiles'] = 0;
        }

        return $WidgetData;
    }

    /**
     * For getting count of sensor detected assets
     *
     * @return data
     */
    function  getSensorDetectedAssetsCount($type)
    {
        return ComplianceDashboardRepository::getSensorDetectedAssetsCount($type);
    }

    /**
     * Retrieves vulnerability data.
     *
     * @return array Returns an array containing vulnerability data.
     */
    public function getVulnerabilityData()
    {
        $types = config('crowdstrike.exprt_rating');

        foreach ($types as $value) {
            $WidgetData[ucfirst(strtolower($value))] = ComplianceDashboardRepository::getVulnerabilityCount($value);
        }

        return $WidgetData;
    }
}
