<?php

namespace App\Services;

use Illuminate\Support\Facades\Log;
use Illuminate\Cache\CacheManager as IlluminateCacheManager;

class CacheManager extends IlluminateCacheManager
{

    protected function createRedisDriver(array $config)
    {
        try {
            $redis = parent::createRedisDriver($config);
            $redis->connection()->ping();

            return $redis;
        } catch (\Exception $e) {
            Log::error($e);

            return $this->resolve('file');
        }
    }
}
