<?php

namespace App\Services\BulkUpload;

use App\Models\AssetStatus;
use App\Models\Asset;
use App\Services\Integrations\Tickets\TicketManagementService;
use Illuminate\Support\Facades\Auth;

class SpecialBulkLostStolenService extends SpecialBulkAbstract
{
	protected $ticketManagementService;

	public function __construct(TicketManagementService $ticketManagementService)
	{
		$this->ticketManagementService = $ticketManagementService;
	}
	/**
	 * Get Headers of CSV
	 * @return array
	 */
	public function getHeaderMap()
	{
		return Config('bulk-upload.lostStolenAssetData');
	}

	/**
	 * Get Status Slug
	 * @return string
	 */
	public function getStatusSlug()
	{
		return "lost_or_stolen";
	}

	/**
	 * Get Data for History and Asset
	 * @param  array  $inputData
	 * @return array            
	 */
	public function getData(Asset $asset)
	{
		$assetData['id'] = $asset->id;
		$assetData['asset_status_id'] = AssetStatus::getStatusID('lost_or_stolen')->first()->id;
		$assetData['loaner_return_date'] = null;
		$assetData['loaner_retention_date'] = null;
		$assetData['lost_date'] = date("m/d/Y");
		$assetData['end_of_life_date'] = null;

		return $assetData;
	}

	/**
	 * Get Default Ticket #
	 * @return String
	 */
	public function getDefaultTicket()
	{
		return Config('tickets.bulk_lost_stolen');
	}

	/**
	 * After bulk upload attach the uploaded file to the ticket as comment
	 * @param mixed $ticketid
	 * @param mixed $filePath
	 * @param mixed $fileName
	 * 
	 * @return [type]
	 */
	public function attachFiletoTicket($ticketid, $filePath, $fileName)
	{
		if (!$ticketid || !$filePath || !$fileName) {
			return false;
		}
		$this->ticketManagementService->attachActionHistorytoTicket($ticketid, 'Bulk lost or stolen (special)', Auth::user()->id, $filePath, $fileName);
		return true;
	}
}
