<?php

namespace App\Services\BulkUpload;

use App\Models\AssetStatus;
use App\Models\Asset;
use App\Services\Integrations\Tickets\TicketManagementService;
use Illuminate\Support\Facades\Auth;

class SpecialBulkInstallService extends SpecialBulkAbstract
{
	protected $ticketManagementService;

	public function __construct(TicketManagementService $ticketManagementService)
	{
		$this->ticketManagementService = $ticketManagementService;
	}
	/**
	 * Get Headers of CSV
	 * @return array
	 */
	public function getHeaderMap()
	{
		return Config('bulk-upload.installAssetData');
	}

	/**
	 * Get Status Slug
	 * @return string
	 */
	public function getStatusSlug()
	{
		return "installed";
	}

	/**
	 * Get Data for History and Asset
	 * @param  array  $inputData
	 * @return array            
	 */
	public function getData(Asset $asset)
	{
		$assetData['id'] = $asset->id;
		$assetData['asset_status_id'] = AssetStatus::getStatusID('installed')->first()->id;
		$assetData['user_id'] = null;
		$assetData['loaner_return_date'] = null;
		$assetData['loaner_retention_date'] = null;
		$assetData['wipe_confirmation'] = null;
		$assetData['lost_date'] = null;
		$assetData['end_of_life_date'] = null;
		$assetData['ticket_no'] = config('tickets.bulk_install');
		return $assetData;
	}

	/**
	 * After bulk upload attach the uploaded file to the ticket as comment
	 * @param mixed $ticketid
	 * @param mixed $filePath
	 * @param mixed $fileName
	 * 
	 * @return [type]
	 */
	public function attachFiletoTicket($ticketid, $filePath, $fileName)
	{
		if (!$ticketid || !$filePath || !$fileName) {
			return false;
		}
		$this->ticketManagementService->attachActionHistorytoTicket($ticketid, 'Bulk install (special)', Auth::user()->id, $filePath, $fileName);
		return true;
	}
}
