<?php

namespace App\Services\BulkUpload;

use App\Models\AssetStatus;
use App\Models\Asset;
use Dotenv\Validator;
use App\Services\Integrations\Tickets\TicketManagementService;
use Illuminate\Support\Facades\Auth;

class SpecialBulkAssignService extends SpecialBulkAbstract
{
	protected $ticketManagementService;

	public function __construct(TicketManagementService $ticketManagementService)
	{
		$this->ticketManagementService = $ticketManagementService;
	}
	/**
	 * Get Headers of CSV
	 * @return array
	 */
	public function getHeaderMap()
	{
		return Config('bulk-upload.assignAssetData');
	}

	/**
	 * Get Status Slug
	 * @return string
	 */
	public function getStatusSlug()
	{
		return "assigned";
	}

	/**
	 * Get Default Ticket #
	 * @return String
	 */
	public function getDefaultTicket()
	{
		return Config('tickets.bulk_assign');
	}


	/**
	 * Get Data for History and Asset
	 * @param  array  $inputData
	 * @return array            
	 */
	public function getData(Asset $asset)
	{
		$assetData['id'] = $asset->id;
		$assetData['asset_status_id'] = AssetStatus::getStatusID('assigned')->first()->id;
		$assetData['location_id']  = null;
		$assetData['loaner_return_date'] = null;
		$assetData['loaner_retention_date'] = null;
		$assetData['wipe_confirmation'] = null;
		$assetData['lost_date'] = null;
		$assetData['end_of_life_date'] = null;
		$assetData['ticket_no'] = $this->getDefaultTicket();

		return $assetData;
	}

	/**
	 * After bulk upload attach the uploaded file to the ticket as comment
	 * @param mixed $ticketid
	 * @param mixed $filePath
	 * @param mixed $fileName
	 * 
	 * @return [type]
	 */
	public function attachFiletoTicket($ticketid, $filePath, $fileName)
	{
		if (!$ticketid || !$filePath || !$fileName) {
			return false;
		}
		$this->ticketManagementService->attachActionHistorytoTicket($ticketid, 'Bulk assign (special)', Auth::user()->id, $filePath, $fileName);
		return true;
	}
}
