<?php

namespace App\Services\AssetHistoryDescriptions;

use App\Models\Asset;
use App\User;
use Auth;
use Facades\App\Services\AssetHistory as AssetHistoryService;

class HistoryForUpdateAssignee implements HistoryDescription
{

    function description($status, $data, $asset, $comments = null)
    {


        $touser = User::where('id', $data['user_id'])->first();
        $newUserName = ($touser != null) ? (' to ' . $touser->first_name . ' ' . $touser->last_name) : " ";
        $commentstext = ($comments != null) ? $commentstext = " with comments \"" . $comments . "\"" : "";

        $oldName = AssetHistoryService::getOldLocationOrUsername($asset);
        $oldUserName = ($oldName != null) ? (' from ' . $oldName) : " ";

        return __('history.updateAssignee', [
            'assetname' => $asset->serial_no,
            'assetid' => $asset->id,
            'oldusername' =>  $oldUserName,
            'newusername' => $newUserName,
            'commenttext' => $commentstext

        ]);
    }
}
