<?php

namespace App\Services\AssetHistoryDescriptions;


class HistoryForStolenLost implements HistoryDescription
{

    /**
     * Generate the history description for a stolen/lost asset.
     *
     * @param string $status
     * @param array $data
     * @param \App\Models\Asset $asset
     * @param string|null $comments
     *
     * @return string
     */
    function description($status, $data, $asset, $comments = null)
    {

        $commentstext = ($comments != null) ? " with comments {$comments} " : "";
        $stolenOrLostDateText = $data['lost_date'] ? " with stolen/lost date updated to {$data['lost_date']}" : "";
        return __('history.StolenLost', [
            'assetname' => $asset->serial_no,
            'assetid' => $asset->id,
            'oldasset_status' => optional($asset->assetStatus)->name,
            'newstatus' => $status,
            'commenttext' => $commentstext,
            'stolenOrLostDateText' => $stolenOrLostDateText,

        ]);
    }
}
