<?php

namespace App\Services\AssetHistoryDescriptions;

use Facades\App\Services\AssetHistory as AssetHistoryService;

class HistoryForRetainHold implements HistoryDescription
{

	/**
	 * Generate the history description for a retain hold asset.
	 *
	 * @param string $status The new status of the asset.
	 * @param array $data Additional data including location and retention date.
	 * @param \App\Models\Asset $asset The asset object containing current asset details.
	 * @param string|null $comments Optional comments regarding the asset.
	 * @return string The formatted history description for the retain hold event.
	 */
	function description($status, $data, $asset, $comments = null)
	{

		$tolocation = AssetHistoryService::getToLocationOrUsername($data);
		$commentstext = ($comments != null) ? " with comments {$comments} " : "";
		$oldName = AssetHistoryService::getOldLocationOrUsername($asset);
		$oldusername = ($oldName != null) ? (' from ' . $oldName) : " ";

		return  __('history.RetainHold', [
			'assetname' => $asset->serial_no,
			'assetid' => $asset->id,
			'oldasset_status' => optional($asset->assetStatus)->name,
			'newstatus' => $status,
			'oldusername' => $oldusername,
			'roomname' => $tolocation,
			'retention_date' => $data['loaner_retention_date'],
			'commenttext' => $commentstext

		]);
	}
}
