<?php

namespace App\Services\AssetHistoryDescriptions;

use App\Models\Vendor;
use Facades\App\Services\AssetHistory as AssetHistoryService;

class HistoryForRMAReturned implements HistoryDescription
{

	/**
	 * Get the description for a common status change history.
	 *
	 * @param string $status
	 * @param array $data
	 * @param \App\Models\Asset $asset
	 * @param string|null $comments
	 *
	 * @return string
	 */
	function description($status, $data, $asset, $comments = null)
	{
		$commentstext = ($comments != null) ? " with comments {$comments} " : "";

		$vendor = Vendor::where('id', $data['vendor_id'] ?? 0)->first();

		return __('history.HistoryForRMAReturned', [
			'assetname'       => $asset->serial_no,
			'assetid'         => $asset->id,
			'oldasset_status' => optional($asset->assetStatus)->name,
			'newstatus'       => $status,
			'vendor'     	  =>  $vendor?->name,
			'commenttext'     => $commentstext

		]);
	}
}
