<?php

namespace App\Services\AssetHistoryDescriptions;

use App\Models\Asset;
use Facades\App\Services\AssetHistory as AssetHistoryService;

class HistoryForLoaned implements HistoryDescription
{

	/**
	 * Create the history description for a loaned asset.
	 *
	 * @param string $status
	 * @param array $data
	 * @param Asset $asset
	 * @param string|null $comments
	 * @return string
	 */
	function description($status, $data, $asset, $comments = null)
	{

		$tousername = AssetHistoryService::getToLocationOrUsername($data);
		$commentstext = ($comments != null) ? " with comments {$comments} " : "";
		$oldName = AssetHistoryService::getOldLocationOrUsername($asset);
		$oldusername = ($oldName != null) ? (' from ' . $oldName) : " ";

		return  __('history.Loaned', [
			'assetname'       => $asset->serial_no,
			'assetid'         => $asset->id,
			'oldasset_status' => optional($asset->assetStatus)->name,
			'newstatus'       => $status,
			'oldusername'     => $oldusername,
			'roomname'        => $tousername,
			'loanerdate'      => $data['loaner_return_date'],
			'commenttext'     => $commentstext

		]);
	}
}
