<?php

namespace App\Services\AssetHistoryDescriptions;


class HistoryForInRepair implements HistoryDescription
{

    /**
     * Generate the history description for in_repair asset.
     *
     * @param string $status
     * @param array $data
     * @param \App\Models\Asset $asset
     * @param string|null $comments
     *
     * @return string
     */
    function description($status, $data, $asset, $comments = null)
    {

        $commentsText = ($comments != null) ? " with comments {$comments} " : "";

        return __('history.InRepair', [
            'assetname' => $asset->serial_no,
            'assetid' => $asset->id,
            'oldasset_status' => optional($asset->assetStatus)->name,
            'newstatus' => $status,
            'commenttext' => $commentsText,
        ]);
    }
}
