<?php

namespace App\Services\AssetHistoryDescriptions;

use App\Models\Vendor;
use Facades\App\Services\AssetHistory as AssetHistoryService;

class HistoryForEndofLifeDataWiped  implements HistoryDescription
{
    /**
     * Generate the history description for an asset that has reached end of life and data has been wiped.
     *
     * @param string $status The new status of the asset.
     * @param array $data Additional data for the description, including vendor information.
     * @param \App\Models\Asset $asset The asset object containing current asset details.
     * @param string|null $comments Optional comments regarding the asset.
     *
     * @return string The formatted description string.
     */
    public function description($status, $data, $asset, $comments = null)
    {

        $commentstext = ($comments != null) ? " with comments {$comments} " : "";
        $vendor   = (!empty($data['vendor_id'])) ? Vendor::select('name')->where('id', $data['vendor_id'])->first() : null;
        // Commented Unused: $oldName = AssetHistoryService::getOldLocationOrUsername($asset);.
        return __('history.HistoryForEndofLifeDataWiped', [
            'assetname' => $asset->serial_no,
            'assetid' => $asset->id,
            'oldasset_status' => optional($asset->assetStatus)->name,
            'newstatus' => $status,
            'commenttext' => $commentstext,
            'vendor' => optional($vendor)->name,

        ]);
    }
}
