<?php

namespace App\Services\AssetHistoryDescriptions;

use App\Models\Asset;
use App\Models\AssetStatus;
use App\Models\Location;
use App\User;
use Illuminate\Support\Facades\Auth;
use Facades\App\Services\AssetHistory as AssetHistoryService;

class HistoryForAsnAssetReceived implements HistoryDescription
{
    public function description($status, $data = null, $asset, $comments = null)
    {

        $inTransit  = AssetStatus::findOrFail($asset->asset_status_id);
        $location   = (!empty($asset->location_id)) ? Location::where('id', $asset->location_id)->first() : null;
        $newLocation   = (!empty($data['location_id'])) ? Location::where('id', $data['location_id'])->first() : null;
        $user       = (!empty($asset->user_id)) ? User::where('id', $asset->user_id)->first() : null;
        $newUser       = (!empty($data['user_id'])) ? User::where('id', $data['user_id'])->first() : null;
        return __('history.Description', [
            'assetname'           => $asset->serial_no,
            'assetid'             => $asset->id,
            'oldasset_status'     => $inTransit->name,
            'newstatus'           => $status ? $status->name : '',
            'old_asset_status_id' => $inTransit->id,
            'new_asset_status_id' => $status ? $status->id : '',
            'oldusername'         => (!empty($user)) ? ' from ' . optional($user)->userName : ((!empty($location)) ? (' from ' . optional($location)->room_name) : ''),
            'roomname'            => (!empty($newLocation)) ? (' to ' . optional($newLocation)->room_name) : ((!empty($newUser)) ? ' to ' . optional($newUser)->userName : ''),
            'commenttext'         => $comments
        ]);
    }
}
