<?php

namespace App\Services\AssetHistoryDescriptions;

use App\Models\AssetStatus;

class HistoryForAsnAssetCreated implements HistoryDescription
{
    public function description($status, $data, $asset, $comments = null)
    {
        $inTransit  = AssetStatus::findOrFail($asset->asset_status_id);

        return __('history.AsnCreated', [
            'assetname' => $asset->serial_no,
            'assetid' => $asset->id,
            'newstatus' => $inTransit->name,
            'new_asset_status_id' => $inTransit->id,
            'oldusername' => '',
            'commenttext' => $comments
        ]);
    }
}
